/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.common.Gauge;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8273.RsPort;
import java.util.Enumeration;
import java.util.Vector;

public class RsModule {
    private String PhyPortComponent = "PhyPort";
    private String RsPortInterfaceComponent = "RsPortInterface";
    private String PhyPortDetailsInfo = "PhyPortDetails";
    private String IntfSummaryInfo = "IntfSummary";
    private String DefaultSchemeId = "default";
    private GenModel deviceModel;
    private GenModel portTableModel;
    private GenModel interfaceModel;
    private int slotNum;
    private int slotType;
    private int slotBaseType;
    private int slotMediaType;
    private Vector portList;
    private Vector subUnitList;

    public RsModule(int n, int n2, GenModel genModel) {
        this.slotNum = n;
        this.slotType = this.slotBaseType = n2;
        this.slotMediaType = 0;
        this.portList = new Vector();
        this.subUnitList = new Vector();
        this.deviceModel = genModel;
    }

    public int getSlotNum() {
        return this.slotNum;
    }

    public int getSlotType() {
        return this.slotType;
    }

    public int getPortMediaType() {
        return this.slotMediaType;
    }

    public int getNumOfPorts() {
        return this.portList.size();
    }

    public RsPort getPortAt(int n) {
        return (RsPort)this.portList.elementAt(n);
    }

    public RsPort getPortWithNum(int n) {
        RsPort rsPort = null;
        Enumeration enumeration = this.portList.elements();
        while (enumeration.hasMoreElements()) {
            RsPort rsPort2 = (RsPort)enumeration.nextElement();
            if (rsPort2.getPortNum() != n) continue;
            rsPort = rsPort2;
            break;
        }
        return rsPort;
    }

    public int getNumOfSubUnits() {
        return this.subUnitList.size();
    }

    public int getSubUnitTypeAt(int n) {
        int n2 = 2;
        RsSubUnit rsSubUnit = (RsSubUnit)this.subUnitList.elementAt(n);
        if (rsSubUnit != null) {
            n2 = rsSubUnit.getSubUnitType();
        }
        return n2;
    }

    public int getSubUnitPosOf(int n) {
        int n2 = 2;
        RsSubUnit rsSubUnit = (RsSubUnit)this.subUnitList.elementAt(n);
        if (rsSubUnit != null) {
            n2 = rsSubUnit.getSubUnitPos();
        }
        return n2;
    }

    public void addSubUnit(int n, int n2) {
        RsSubUnit rsSubUnit = new RsSubUnit(n, n2);
        this.subUnitList.addElement(rsSubUnit);
    }

    public void addPort(int n, int n2) {
        Object object;
        int n3 = n;
        if (this.slotMediaType == 0 && this.slotType != 5 && this.slotType != 15) {
            try {
                if (this.portTableModel == null) {
                    this.portTableModel = (GenModel)this.deviceModel.getComponent(this.PhyPortComponent);
                }
                object = new ModelInfo();
                ((ModelInfo)object).add("Index.Slot", new Integer(this.slotNum));
                ((ModelInfo)object).add("Index.Port", new Integer(n));
                object = this.portTableModel.getInfo(this.PhyPortDetailsInfo, this.DefaultSchemeId, (ModelInfo)object);
                if (object != null && ((ModelInfo)object).get("PhyPortDetails.PhyPortMediaType") instanceof Integer) {
                    this.slotMediaType = (Integer)((ModelInfo)object).get("PhyPortDetails.PhyPortMediaType");
                } else if (n == 1 && n2 == 30) {
                    this.slotMediaType = 4;
                    n3 = 2;
                }
                if (this.slotMediaType == 3) {
                    if (this.interfaceModel == null) {
                        this.interfaceModel = (GenModel)this.deviceModel.getComponent(this.RsPortInterfaceComponent);
                    }
                    ModelInfo modelInfo = new ModelInfo();
                    int n4 = this.slotNum * 100 + n;
                    long l = 100000000L;
                    modelInfo.add("Index.IfIndex", new Integer(n4));
                    modelInfo = this.interfaceModel.getInfo(this.IntfSummaryInfo, this.DefaultSchemeId, modelInfo);
                    if (modelInfo != null && modelInfo.get("IntfSummary.IfSpeed") instanceof Gauge && ((Gauge)modelInfo.get((String)"IntfSummary.IfSpeed")).value == l) {
                        this.slotMediaType = 4;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = new RsPort(this.slotNum, n3, n2);
        this.portList.addElement(object);
    }

    class RsSubUnit {
        private int subUnit;
        private int subUnitType;

        RsSubUnit(int n, int n2) {
            RsModule.this = RsModule.this;
            this.subUnit = n;
            this.subUnitType = n2;
        }

        int getSubUnitPos() {
            return this.subUnit;
        }

        int getSubUnitType() {
            return this.subUnitType;
        }
    }
}

